---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：25-Disruption Budgetコントローラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **trySync/failSafeの詳細行番号**：ファイルの読み取り範囲が120行目までに制限されているため、trySync以降の詳細な行番号確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/controller/disruption/disruption.go` 69行目（DeletionTimeout定数）
- E-02: `pkg/controller/disruption/disruption.go` 76行目（stalePodDisruptionTimeout定数）
- E-03: `pkg/controller/disruption/disruption.go` 81-120行目（DisruptionController構造体）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 45行目（kubectl drain連携）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` 26行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DeletionTimeout=2分 | E-01 | ○ |
| C-02 | stalePodDisruptionTimeout=2分 | E-02 | ○ |
| C-03 | 3つのキュー: queue, recheckQueue, stalePodDisruptionQueue | E-03 (107-112行目) | ○ |
| C-04 | recheckQueueはDelayingQueue | E-03 (108行目) | ○ |
| C-05 | stalePodDisruptionQueueはRateLimitingQueue | E-03 (111行目) | ○ |
| C-06 | 各種Lister（PDB, Pod, RC, RS, Deployment, SS）を保持 | E-03 (88-104行目) | ○ |
| C-07 | clockインターフェースを使用 | E-03 (119行目) | ○ |
| C-08 | kubectl drainとAPI連携 | E-04 | ○ |
| C-09 | DisruptionsAllowed = max(0, currentHealthy - desiredHealthy) | E-05 | ○ |
| C-10 | MinAvailable/MaxUnavailableによる可用性計算 | E-05 | ○ |
| C-11 | フェイルセーフでDisruptionsAllowed=0 | E-05 (概要説明より) | ○ |
| C-12 | broadcaster/recorderを保持 | E-03 (114-115行目) | ○ |
| C-13 | Scale APIで期待レプリカ数取得 | E-03 (85行目 scaleNamespacer) | ○ |
| C-14 | Discovery APIで動的リソース検出 | E-03 (86行目 discoveryClient) | ○ |
| C-15 | trySync/failSafeの詳細行番号 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15: trySync()やfailSafe()の具体的な行番号は120行目以降にあり、読み取り範囲外
  - 候補：`pkg/controller/disruption/disruption.go` 120行目以降を直接確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 構造体定義と定数は確認済み
- 1: 中リスク - trySync()のDisruptionsAllowed算出ロジックの詳細行番号未確認

## 6) レビュアーチェックリスト（最小）
- [ ] DisruptionController構造体の3キュー構成がコードと一致しているか確認
- [ ] trySync()のDisruptionsAllowed算出ロジックを直接確認
- [ ] failSafe()のDisruptionsAllowed=0設定を直接確認
- [ ] DeletionTimeout/stalePodDisruptionTimeoutの動作を確認
